
struct Vert{
    vec4 pos_and_sz;
    vec4 colour;
    bool is_const_size;
    int transforms_buff_id;
    float d;
    float e;
};

//uniform Vert* vert_buffa;
//uniform mat4* transforms_buff;

layout(std430, binding = 6) buffer aaaGGG {
    Vert[] vert_buff;
};

layout(std430, binding = 10) buffer ggafffsdg {
    mat4[] transforms_buff;
};

out vec3 out_pos;
//out float point_sz;
out vec4 color;
out float radial_uv;
out float dof_amt;

const vec2 circleVertices[16] = vec2[](
    vec2(1.000000f, 0.000000f),
    vec2(0.923880f, 0.382683f),
    vec2(0.707107f, 0.707107f),
    vec2(0.382683f, 0.923880f),
    vec2(-0.000000f, 1.000000f),
    vec2(-0.382684f, 0.923880f),
    vec2(-0.707107f, 0.707107f),
    vec2(-0.923880f, 0.382683f),
    vec2(-1.000000f, -0.000000f),
    vec2(-0.923880f, -0.382683f),
    vec2(-0.707107f, -0.707107f),
    vec2(-0.382683f, -0.923880f),
    vec2(0.000000f, -1.000000f),
    vec2(0.382684f, -0.923879f),
    vec2(0.707107f, -0.707107f),
    vec2(0.923880f, -0.382683f)
);



void main() {
    int tris_per_point = 16;
    
    int tri_id = gl_VertexID/(3*tris_per_point);
//    tri_id = 0;
    int sub_tri_id = (gl_VertexID/(3)) % tris_per_point;
    
    
//    int sub_vert_id = gl_VertexID % 3;
//    int next_vert_id = vert_id + 1;
    
    vec3 ws_pos = vert_buff[tri_id].pos_and_sz.xyz;
    vec4 col = vert_buff[tri_id].colour;
    float sz = vert_buff[tri_id].pos_and_sz.w;
    bool is_const_size = vert_buff[tri_id].is_const_size;
    
    int trans_idx = vert_buff[tri_id].transforms_buff_id;

    mat4 trans = trans_idx >= 0 ? transforms_buff[trans_idx] : mat4(1);
    
//    float sz = 0.02;
    
//    vec4 col = vec4(1,0,0,1);
    vec4 curr_vert_proj = V * trans * vec4(ws_pos,1);
    float depth = curr_vert_proj.z;
    
    bool dof = false;
    
    if(dof){
        float focus_dist = 0.6;
        float dof_scale = 20.9;
        dof_amt = abs(-depth-focus_dist) * dof_scale * 2.5;
        //    dof_amt = -(1.-(-depth/focus_dist))*dof_scale;
        dof_amt = abs(dof_amt);
        
    }
    

//    coc = -(1.-(-depth/focus_dist))*dof_scale;
//    if(abs(-depth-focus_dist) > 0.2){
//        return;
//    }
    curr_vert_proj = P * curr_vert_proj;
    vec3 curr_vert_ndc = curr_vert_proj.xyz / curr_vert_proj.w;
    
    vec2 w = vec2(1,R.x/R.y);
    
    float offs_idx = float(
        sub_tri_id - float(max(int(gl_VertexID)%3 - 0, 0))
    )/float(tris_per_point);
    
//    vec2 offs = gl_VertexID%3 == 0 ? vec2(0) : vec2(
//        sin(offs_idx * tau), cos(offs_idx * tau)
//    ) * sz * w;
    vec2 offs_normalized = gl_VertexID%3 == 0 ? vec2(0) : vec2(
        sin(offs_idx * tau), cos(offs_idx * tau)
    );

    vec2 offs = offs_normalized * sz * w * ( dof ? 1. + dof_amt : 1.);
//    vec2 offs = 
//        gl_VertexID%3 == 0 ? vec2(0) : 
//        circleVertices[sub_tri_id - (max(int(gl_VertexID)%3 - 0, 0))]*sz*w;
    if(!is_const_size){
        offs /= depth;
        offs *= 10.0;
    }
    
//    offs = vec2(sin(float(gl_VertexID)*4.), cos(float(gl_VertexID)))*sz*w;
    
    vec2 vert_ndc = curr_vert_ndc.xy + offs;

    vec4 pp = vec4(vert_ndc * curr_vert_proj.w, curr_vert_proj.zw);
    
    radial_uv = gl_VertexID%3 == 0  ? 0.0 : 1.;

    color = col;
    
    const vec4 proj_offs = vec4(0,0,0.000,0);
    const vec4 sc = vec4(vec3(1.,1.,1.)*0.9999,1);
    pp -= proj_offs;
    pp *= sc;
    
//    print(curr_vert_ndc.xy);

    gl_Position = pp;
}
